/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.util.leap.EnumIterator;
import jade.util.leap.Serializable;
import java.util.Vector;

class Scheduler
implements Serializable {
    protected Vector readyBehaviours = new Vector();
    protected Vector blockedBehaviours = new Vector();
    private Agent owner;
    private int currentIndex;

    public Scheduler(Agent a) {
        this.owner = a;
        this.currentIndex = 0;
    }

    public synchronized void add(Behaviour b) {
        this.readyBehaviours.addElement(b);
        this.notify();
    }

    public synchronized void block(Behaviour b) {
        if (this.removeFromReady(b)) {
            this.blockedBehaviours.addElement(b);
        }
    }

    public synchronized void restart(Behaviour b) {
        if (this.removeFromBlocked(b)) {
            this.readyBehaviours.addElement(b);
            this.notify();
        }
    }

    public synchronized void restartAll() {
        Behaviour[] behaviours = new Behaviour[this.readyBehaviours.size()];
        int counter = 0;
        EnumIterator it = new EnumIterator(this.readyBehaviours.elements());
        while (it.hasNext()) {
            behaviours[counter++] = (Behaviour)it.next();
        }
        int i = 0;
        while (i < behaviours.length) {
            Behaviour b = behaviours[i];
            b.restart();
            ++i;
        }
        behaviours = new Behaviour[this.blockedBehaviours.size()];
        counter = 0;
        EnumIterator it2 = new EnumIterator(this.blockedBehaviours.elements());
        while (it2.hasNext()) {
            behaviours[counter++] = (Behaviour)it2.next();
        }
        int i2 = 0;
        while (i2 < behaviours.length) {
            Behaviour b = behaviours[i2];
            b.restart();
            ++i2;
        }
    }

    public synchronized void remove(Behaviour b) {
        boolean found = this.removeFromBlocked(b);
        if (!found) {
            found = this.removeFromReady(b);
        }
        if (found) {
            // empty if block
        }
    }

    public synchronized Behaviour schedule() throws InterruptedException {
        while (this.readyBehaviours.isEmpty()) {
            this.owner.idle();
        }
        Behaviour b = (Behaviour)this.readyBehaviours.elementAt(this.currentIndex);
        this.currentIndex = (this.currentIndex + 1) % this.readyBehaviours.size();
        return b;
    }

    private boolean removeFromBlocked(Behaviour b) {
        return this.blockedBehaviours.removeElement(b);
    }

    private boolean removeFromReady(Behaviour b) {
        int index = this.readyBehaviours.indexOf(b);
        if (index != -1) {
            this.readyBehaviours.removeElement(b);
            if (index < this.currentIndex) {
                --this.currentIndex;
            } else if (index == this.currentIndex && this.currentIndex == this.readyBehaviours.size()) {
                this.currentIndex = 0;
            }
        }
        return index != -1;
    }
}

